/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.compat.mod;

import com.charles445.simpledifficulty.SimpleDifficulty;
import com.charles445.simpledifficulty.config.ModConfig;
import com.charles445.simpledifficulty.temperature.ModifierBase;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HarvestFestivalModifier
extends ModifierBase {
    private boolean enabled;
    private Class HFApi;
    private Class CalendarManager;
    private Class Season;
    private Class CalendarDate;
    private Field f_HFApi_calendar;
    private Object o_CalendarManager;
    private Method m_CalendarManager_getSeasonAtCoordinates;
    private Method m_CalendarManager_getDate;
    private Method m_CalendarDate_getSeason;

    public HarvestFestivalModifier() {
        super("HarvestFestival");
        try {
            this.HFApi = Class.forName("joshie.harvest.api.HFApi");
            this.CalendarManager = Class.forName("joshie.harvest.api.calendar.CalendarManager");
            this.Season = Class.forName("joshie.harvest.api.calendar.Season");
            this.CalendarDate = Class.forName("joshie.harvest.api.calendar.CalendarDate");
            this.f_HFApi_calendar = this.HFApi.getDeclaredField("calendar");
            this.o_CalendarManager = this.CalendarManager.cast(this.f_HFApi_calendar.get(this.CalendarManager.getClass()));
            this.m_CalendarManager_getSeasonAtCoordinates = this.CalendarManager.getMethod("getSeasonAtCoordinates", World.class, BlockPos.class);
            this.m_CalendarManager_getDate = this.CalendarManager.getMethod("getDate", World.class);
            this.m_CalendarDate_getSeason = this.CalendarDate.getMethod("getSeason", new Class[0]);
            this.enabled = true;
            if (!this.Season.isEnum()) {
                SimpleDifficulty.logger.error("HarvestFestivalModifier reflection failed! Season was not an enum! Harvest Festival compatibility is now disabled!");
                this.enabled = false;
            }
        }
        catch (Exception e) {
            SimpleDifficulty.logger.error("HarvestFestivalModifier reflection failed! Harvest Festival compatibility is now disabled!", (Throwable)e);
            this.enabled = false;
        }
    }

    @Override
    public float getWorldInfluence(World world, BlockPos pos) {
        if (this.enabled && world.field_73011_w.func_76569_d() && ModConfig.server.compatibility.toggles.harvestFestival) {
            try {
                Object o_DateResult;
                Object o_SeasonResult = this.m_CalendarManager_getSeasonAtCoordinates.invoke(this.o_CalendarManager, world, pos);
                if (o_SeasonResult == null && (o_DateResult = this.m_CalendarManager_getDate.invoke(this.o_CalendarManager, world)) != null) {
                    o_SeasonResult = this.m_CalendarDate_getSeason.invoke(this.CalendarDate.cast(o_DateResult), new Object[0]);
                }
                if (o_SeasonResult == null) {
                    return 0.0f;
                }
                switch (((Enum)o_SeasonResult).name()) {
                    case "SPRING": {
                        return this.applyUndergroundEffect(ModConfig.server.compatibility.harvestfestival.seasonSpring, world, pos);
                    }
                    case "SUMMER": {
                        return this.applyUndergroundEffect(ModConfig.server.compatibility.harvestfestival.seasonSummer, world, pos);
                    }
                    case "AUTUMN": {
                        return this.applyUndergroundEffect(ModConfig.server.compatibility.harvestfestival.seasonAutumn, world, pos);
                    }
                    case "WINTER": {
                        return this.applyUndergroundEffect(ModConfig.server.compatibility.harvestfestival.seasonWinter, world, pos);
                    }
                }
                return 0.0f;
            }
            catch (Exception e) {
                SimpleDifficulty.logger.error("HarvestFestivalModifier reflection failed during getWorldInfluence! Harvest Festival compatibility is now disabled!", (Throwable)e);
                this.enabled = false;
            }
        }
        return 0.0f;
    }
}

